# Towers of Hanoi — Recursive Solver (Java)

## 1) Objective

Move a stack of **n disks** from a **start** peg to a **target** peg using one **auxiliary** peg, obeying the rules:

1. move **one** disk at a time,
2. never place a larger disk on top of a smaller one.

This implementation solves the problem **recursively** and prints the sequence of moves in the format `start->end`.

> Class demo reference: `ToHSolver.moveTower(n, start, end, extra)` invoked by `solve()` with pegs **1 → 3** using **2** as auxiliary.

---

## 2) Tracing the recursive solution for n = 0, 1, 2

We use the class definition:

```java
private void moveTower(int n, int start, int end, int extra) {
  if (n == 0) return;                  // base case
  moveTower(n - 1, start, extra, end); // move n-1 to aux
  moveOneDisk(start, end);             // move largest n-th disk
  moveTower(n - 1, extra, end, start); // move n-1 onto target
}
```

### n = 0

- Call: `moveTower(0, 1, 3, 2)` → hits **base case**, **no moves printed**.

### n = 1

- Call: `moveTower(1, 1, 3, 2)`

  - `moveTower(0, 1, 2, 3)` → nothing to do (base case)
  - `moveOneDisk(1, 3)` → prints **`1->3`**
  - `moveTower(0, 2, 3, 1)` → nothing to do

- **Moves:** `1->3`

### n = 2

- Call: `moveTower(2, 1, 3, 2)`

  - `moveTower(1, 1, 2, 3)` → prints `1->2`
  - `moveOneDisk(1, 3)` → prints `1->3`
  - `moveTower(1, 2, 3, 1)` → prints `2->3`

- **Moves (in order):**

```
1->2
1->3
2->3
```

Call stack outline for n = 2:

```
moveTower(2,1,3,2)
  ├─ moveTower(1,1,2,3)  → 1->2
  ├─ moveOneDisk(1,3)    → 1->3
  └─ moveTower(1,2,3,1)  → 2->3
```

---

## 3) Time & Space Complexity

- **Number of moves:** (T(n) = 2^n - 1) (optimal and necessary). The solver prints exactly this many moves.
- **Time complexity:** (O(2^n)) — each level doubles the work plus one move.
- **Space complexity:** (O(n)) — maximum recursion depth is (n); Java does not eliminate frames (no TCO).
- **Iterative note (not implemented):** An iterative approach based on binary/Gray-code patterns exists; it has the **same asymptotic time** ((2^n - 1) moves) and **O(n)** auxiliary space for representing pegs, but avoids recursive call-stack growth.

**Practical considerations:** very large (n) will lead to long runtimes and, if recursion depth exceeds stack limits, `StackOverflowError`.
